<?php

class Paypal extends PaymentModule
{
	private	$_html = '';
	private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'paypal';
		$this->tab = 'Payment';
		$this->version = 1.02;

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Paypal');
        $this->description = $this->l('Accepts payments by Paypal');
	}

	public function getPaypalUrl()
	{
			return Configuration::get('PAYPAL_SANDBOX') ? 'https://www.sandbox.paypal.com/cgi-bin/webscr' : 'https://www.paypal.com/cgi-bin/webscr';
	}

	public function install()
	{
		parent::install();
		Configuration::updateValue('PAYPAL_BUSINESS', 'your-paypal@address.com');
		Configuration::updateValue('PAYPAL_SANDBOX', 1);
		Configuration::updateValue('PAYPAL_CURRENCY', 'customer');
		$this->registerHook('payment');
	}

	public function uninstall()
	{
		Configuration::deleteByName('PAYPAL_BUSINESS');
		Configuration::deleteByName('PAYPAL_SANDBOX');
		Configuration::deleteByName('PAYPAL_CURRENCY');
		parent::uninstall();
	}

	public function getContent()
	{
		$this->_html = '<h2>Paypal</h2>';
		if (isset($_POST['submitPaypal']))
		{
			if (empty($_POST['business']))
				$this->_postErrors[] = 'Paypal business e-mail address is required.';
			elseif (!Validate::isEmail($_POST['business']))
				$this->_postErrors[] = 'Paypal business must be an e-mail address.';
			if (!isset($_POST['sandbox']))
				$_POST['sandbox'] = 1;
			if (empty($_POST['currency']))
				$_POST['currency'] = 'customer';
			if (!sizeof($this->_postErrors))
			{
				Configuration::updateValue('PAYPAL_BUSINESS', $_POST['business']);
				Configuration::updateValue('PAYPAL_SANDBOX', intval($_POST['sandbox']));
				Configuration::updateValue('PAYPAL_CURRENCY', $_POST['currency']);
				$this->displayConf();
			}
			else
				$this->displayErrors();
		}

		$this->displayPayPal();
		$this->displayFormSettings();
		return $this->_html;
	}

	public function displayConf()
	{
		$this->_html .= '
		<div class="conf confirm">
			<img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />
			'.$this->l('Settings updated').'
		</div>';
	}

	public function displayErrors()
	{
		$nbErrors = sizeof($this->_postErrors);
		$this->_html .= '
		<div class="alert error">
			<h3>'.($nbErrors > 1 ? $this->l('There are') : $this->l('There is')).' '.$nbErrors.' '.($nbErrors > 1 ? $this->l('errors') : $this->l('error')).'</h3>
			<ol>';
		foreach ($this->_postErrors AS $error)
			$this->_html .= '<li>'.$error.'</li>';
		$this->_html .= '
			</ol>
		</div>';
	}
	
	
	public function displayPayPal()
	{
		$this->_html .= '<img src="../modules/paypal/paypal.gif" style="float:left; margin-right:15px;"><b>'.$this->l('This module allows you to accept payments by PayPal.').'</b><br /><br />
		'.$this->l('If the client chooses this payment mode, your account PayPal will be automatically credited.').'<br />
		'.$this->l('You need to configure first your PayPal account to use this module.').'<br /><br /><br />';
	}

	public function displayFormSettings()
	{
		$conf = Configuration::getMultiple(array('PAYPAL_BUSINESS', 'PAYPAL_SANDBOX'));
		$business = array_key_exists('business', $_POST) ? $_POST['business'] : (array_key_exists('PAYPAL_BUSINESS', $conf) ? $conf['PAYPAL_BUSINESS'] : '');
		$sandbox = array_key_exists('sandbox', $_POST) ? $_POST['sandbox'] : (array_key_exists('PAYPAL_SANDBOX', $conf) ? $conf['PAYPAL_SANDBOX'] : '');
		$currency = array_key_exists('currency', $_POST) ? $_POST['currency'] : (array_key_exists('PAYPAL_CURRENCY', $conf) ? $conf['PAYPAL_CURRENCY'] : 'default');

		$this->_html .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
		<fieldset>
			<legend><img src="../img/admin/contact.gif" />'.$this->l('Settings').'</legend>
			<label>'.$this->l('Paypal business e-mail').'</label>
			<div class="margin-form"><input type="text" size="33" name="business" value="'.$business.'" /></div>
			<label>'.$this->l('Sandbox mode').'</label>
			<div class="margin-form">
				<input type="radio" name="sandbox" value="1" '.($sandbox ? 'checked="checked"' : '').' /> '.$this->l('Yes').'
				<input type="radio" name="sandbox" value="0" '.(!$sandbox ? 'checked="checked"' : '').' /> '.$this->l('No').'
			</div>
			<label>'.$this->l('Currency').'</label>
			<div class="margin-form">
				<input type="radio" name="currency" value="default" '.($currency == 'default' ? 'checked="checked"' : '').' /> '.$this->l('Use default currency').'
				<br /><input type="radio" name="currency" value="customer" '.($currency == 'customer' ? 'checked="checked"' : '').' /> '.$this->l('Use customer currency').'
			</div>
			<br /><center><input type="submit" name="submitPaypal" value="'.$this->l('Update settings').'" class="button" /></center>
		</fieldset>
		</form><br /><br />
		<fieldset class="width3">
			<legend><img src="../img/admin/warning.gif" />'.$this->l('Informations').'</legend>
			'.$this->l('In order to use your PayPal payment module, you have to configure your PayPal account (sandbox account as well as real one). Log in to PayPal and follow theses directives.').'<br /><br />
			'.$this->l('In').' <i>Profile > Selling Preferences > Instant Payment Notification Preferences</i>, '.$this->l('set:').'<br />
			- <b>Instant Payment Notification (IPN)</b> '.$this->l('to').' <b>On</b>,<br />
			- <b>Instant Payment Notification (IPN) URL</b> '.$this->l('to').' <b>http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/'.$this->name.'/validation.php</b>.<br /><br />
			'.$this->l('In').' <i>Profile > Selling Preferences > Website Payment Preferences</i>, '. $this->l('set:').'<br />
			- <b>Auto Return</b> '.$this->l('to whatever you choose').' (<b>On</b> '.$this->l('is recommended').'),<br />
			- <b>Return URL</b> '.$this->l('to').' <b>http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'order-confirmation.php</b>.<br />
			- <b>Payment Data Transfer</b> '.$this->l('to').' <b>Off</b>.
		</fieldset>';
	}

	public function hookPayment($params)
	{
		global $smarty;

		$address = new Address(intval($params['cart']->id_address_invoice));
		$customer = new Customer(intval($params['cart']->id_customer));
		$business = Configuration::get('PAYPAL_BUSINESS');

		if (Configuration::get('PAYPAL_CURRENCY') == 'customer')
			$id_currency = intval($params['cart']->id_currency);
		else
			$id_currency = intval(Configuration::get('PS_CURRENCY_DEFAULT'));

		$currency = new Currency(intval($id_currency));

		if (!Validate::isEmail($business))
			return 'Paypal error: (invalid or undefined business account email)';

		if (!Validate::isLoadedObject($address) OR !Validate::isLoadedObject($customer) OR !Validate::isLoadedObject($currency))
			return 'Paypal error: (invalid address or customer)';
		$smarty->assign(array(
			'address' => $address,
			'customer' => $customer,
			'business' => $business,
			'currency' => $currency,
			'paypalUrl' => $this->getPaypalUrl(),
			'amount' => number_format(Tools::convertPrice($params['cart']->getOrderTotal(true, 4), $currency), 2, '.', ''),
			'shipping' => Tools::convertPrice($params['cart']->getOrderShippingCost(), $currency),
			'discounts' => $params['cart']->getDiscounts(),
			'products' => $params['cart']->getProducts(),
			'total' => number_format(Tools::convertPrice($params['cart']->getOrderTotal(true, 4), $currency), 2, '.', ''),
			'id_cart' => intval($params['cart']->id)
		));

		return $this->display(__FILE__, 'paypal.tpl');
    }
}

?>