<?php

include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/paypal.php');

$errors = '';
$paypal = new Paypal();

$params = 'cmd=_notify-validate';
foreach ($_POST AS $key => $value)
	$params .= '&'.$key.'='.urlencode(stripslashes($value));
	
$paypalServer = 'www.'.(Configuration::get('PAYPAL_SANDBOX') ? 'sandbox.' : '').'paypal.com';

$header = 'POST /cgi-bin/webscr HTTP/1.0'."\r\n" .
          'Host: '.$paypalServer."\r\n".
          'Content-Type: application/x-www-form-urlencoded'."\r\n".
          'Content-Length: '.strlen($params)."\r\n".
          'Connection: close'."\r\n\r\n";

if ($fd = fsockopen($paypalServer, 80, $errno, $errstr, 30))
{
	fputs($fd, $header.$params);
	
	$status = false;
    while (!feof($fd))
		if (trim(fgets($fd, 1024)) == 'VERIFIED')
		{
		 	$status = true;
			break;
		}
	fclose ($fd);
	
	if ($status)
	{
		if (!isset($_POST['mc_gross']))
			$errors .= 'Paypal key \'mc_gross\' not specified, can\'t control amount paid.<br />';
		if (!isset($_POST['payment_status']))
			$errors .= 'Paypal key \'payment_status\' not specified, can\'t control payment validity<br />';
		elseif ($_POST['payment_status'] != 'Completed')
			$errors .= 'Payment : '.$_POST['payment_status'].'<br />';
		if (!isset($_POST['custom']))
			$errors .= 'Paypal key \'custom\' not specified, can\'t rely to cart<br />';
		if (!isset($_POST['txn_id']))
			$errors .= 'Paypal key \'txn_id\' not specified, transaction unknown<br />';
		if (!isset($_POST['mc_currency']))
			$errors .= 'Paypal key \'mc_currency\' not specified, currency unknown<br />';
		if (empty($errors))
		{
			$cart = new Cart(intval($_POST['custom']));
			if (!$cart->id)
				$errors = 'Cart not found<br />';
			elseif (Order::getOrderByCartId($_POST['custom']))
				$errors = 'Order has already been placed<br />';
			else
				$paypal->validateOrder($_POST['custom'], _PS_OS_PAYMENT_, $_POST['mc_gross'], $paypal->displayName, 'Paypal Transaction ID : '.$_POST['txn_id']);
		}
	}
	else
		$errors .= 'PayPal payment not set to VERIFIED but '.$read.'<br />';
	
}
else
	$errors .= 'Impossible to connect to PayPal server';

if (!empty($errors) AND isset($_POST['custom']))
	$paypal->validateOrder(intval($_POST['custom']), _PS_OS_ERROR_, 0, $paypal->displayName, $errors);

?>