<?php

class sendToAFriend extends Module
{
 	function __construct()
 	{
 	 	$this->name = 'sendtoafriend';
 	 	$this->version = '1.1';
 	 	$this->tab = 'Products';
		
		parent::__construct();
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Send to a friend module');
		$this->description = $this->l('Allow customers to send product link to a friend');
 	}

	function install()
	{
	 	if (!parent::install())
	 		return false;
	 	return $this->registerHook('extra');
	}
	
	function hookExtra($params)
	{
		global $smarty;

		$smarty->assign('this_path', $this->_path);
		return $this->display(__FILE__, 'product_page.tpl');
	}

	public function displayFrontForm()
	{
		global $smarty;
		$error = false;
		$confirm = false;
		
		if (isset($_POST['submitAddtoafriend']))
		{
			global $cookie, $link;
			/* Product informations */
			$product = new Product(intval(Tools::getValue('id_product')), false, intval($cookie->id_lang));
			$productLink = $link->getProductLink(intval($product->id), $product->link_rewrite);
			$backToProduct = '<a href="'.$productLink.'" class="bold">'.Tools::l('Back to', 'sendtoafriend', __FILE__).' "'.$product->name.'"</a>';
			$smarty->assign('backToProduct', $backToProduct);
			
			/* Fields verifications */
			if (empty($_POST['email']) OR empty($_POST['name']))
				$error = Tools::l('You must fill all fields.', 'sendtoafriend', __FILE__);
			elseif (!Validate::isEmail($_POST['email']))
				$error = Tools::l('Your friend\'s email is invalid.', 'sendtoafriend', __FILE__);
			elseif (!Validate::isName($_POST['name']))
				$error = Tools::l('Your friend\'s name is invalid.', 'sendtoafriend', __FILE__);
			elseif (!isset($_GET['id_product']) OR !is_numeric($_GET['id_product']))
				$error = Tools::l('An error occured during the process.', 'sendtoafriend', __FILE__);
			else
			{
				/* Email generation */
				$subject = ($cookie->customer_surname ? $cookie->customer_surname.' '.$cookie->customer_name : Tools::l('A friend', 'sendtoafriend', __FILE__)).' '.Tools::l('send you a link to', 'sendtoafriend', __FILE__).' '.$product->name;
				$templateVars = array(
					'{product}' => $product->name,
					'{product_link}' => 'http://'.$_SERVER['HTTP_HOST'].$productLink,
					'{customer}' => ($cookie->customer_surname ? $cookie->customer_surname.' '.$cookie->customer_name : Tools::l('A friend', 'sendtoafriend', __FILE__)),
					'{name}' => Tools::safeOutput($_POST['name'])
				);
				
				/* Email sending */
				if (!Mail::Send(intval($cookie->id_lang), 'send_to_a_friend', $subject, $templateVars, $_POST['email'], NULL, ($cookie->email ? $cookie->email : NULL), ($cookie->customer_surname ? $cookie->customer_surname.' '.$cookie->customer_name : NULL)))
					$error = Tools::l('An error occured during the sending process.', 'sendtoafriend', __FILE__);
				else
					$confirm = Tools::l('An email have been sent successfully to', 'sendtoafriend', __FILE__).' '.Tools::safeOutput($_POST['email']).'.';
			}
		}
		else
		{
			global $cookie, $link;
			/* Product informations */
			$product = new Product(intval(Tools::getValue('id_product')), false, intval($cookie->id_lang));
			$productLink = $link->getProductLink(intval($product->id), $product->link_rewrite);
		}
		
		/* Image */
		$images = $product->getImages(intval($cookie->id_lang));
		foreach ($images AS $k => $image)
			if ($image['cover'])
			{
				$cover['id_image'] = intval($product->id).'-'.intval($image['id_image']);
				$cover['legend'] = $image['legend'];
			}
		
		if (!isset($cover))
			$cover = array('id_image' => Language::getIsoById(intval($cookie->id_lang)).'-default', 'legend' => 'No picture');
		
		$smarty->assign(array(
			'cover' => $cover,
			'error' => $error,
			'confirm' => $confirm,
			'product' => $product,
			'productLink' => $productLink
		));

		return $this->display(__FILE__, 'sendtoafriend.tpl');
	}
}
?>