<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');
$errors = array();

if (!$cookie->isLogged())
	Tools::redirect('authentication.php?back=history.php');

if (isset($_POST['submitMessage']) OR isset($_POST['submitMessage_x']) OR isset($_POST['submitMessage_y']))
{
	if (!isset($_POST['id_order']) OR !Validate::isUnsignedId($_POST['id_order']))
		$errors[] = Tools::displayError('order is no longer valid');
	elseif (empty($_POST['msgText']))
		$errors[] = Tools::displayError('message cannot be blank');
	elseif (!Validate::isMessage($_POST['msgText']))
		$errors[] = Tools::displayError('message is not valid (HTML is not allowed)');
	
	if(!sizeof($errors))
	{
	 	$order = new Order(intval($_POST['id_order']));	 	
	 	if (Validate::isLoadedObject($order) AND ($order->id_customer == $cookie->id_customer))
	 	{
			$message = new Message();
			$message->id_customer = intval($cookie->id_customer);
			$message->message = $_POST['msgText'];
			$message->id_order = intval($_POST['id_order']);
			$message->private = false;
			$message->add();
			$to = strval(Configuration::get('PS_SHOP_EMAIL'));
			$toName = strval(Configuration::get('PS_SHOP_NAME'));
			$customer = new Customer(intval($cookie->id_customer));
			if (Validate::isLoadedObject($customer))
				Mail::Send(intval($cookie->id_lang), 'order_customer_comment', 'Message from a customer', 
				array('{genre}' => Gender::getNameById($message->id_customer), '{name}' => $customer->name, '{surname}' => $customer->surname, '{id_order}' => $message->id_order, '{message}' => $message->message),
				$to, $toName, $customer->email, $customer->surname.' '.$customer->name);
			Tools::redirect('order-detail.php?id_order='.intval($_POST['id_order']));
		}
		else
			$errors[] = Tools::displayError('order not found');
	}
}

if (!isset($_GET['id_order']) OR !Validate::isUnsignedId($_GET['id_order']))
	$errors[] = Tools::displayError('order id is required');
else
{
	$order = new Order(intval($_GET['id_order']));	
	if (Validate::isLoadedObject($order) AND ($order->id_customer == $cookie->id_customer))
	{
		$id_order_state = $order->getCurrentState();
		$carrier = new Carrier(intval($order->id_carrier), intval($order->id_lang));
		if ($order->total_discounts > 0)
		    $smarty->assign('total_old', floatval($order->total_paid - $order->total_discounts));
			
		$smarty->assign('order', $order);
		$smarty->assign('currency', new Currency($order->id_currency));
		$smarty->assign('order_state', $id_order_state);
		$smarty->assign('invoice', OrderState::invoiceAvailable($id_order_state));
		$smarty->assign('order_history', $order->getHistory(intval($cookie->id_lang)));		
		$smarty->assign('products', $order->getProducts());
		$smarty->assign('discounts', $order->getDiscounts());
		$smarty->assign('carrier', $carrier);
		$smarty->assign('address_invoice', new Address(intval($order->id_address_invoice)));
		$smarty->assign('address_delivery', new Address(intval($order->id_address_delivery)));
		$smarty->assign('messages', Message::getMessagesByOrderId(intval($order->id), true));
		if ($carrier->url AND $order->shipping_number)
			$smarty->assign('followup', str_replace('@', $order->shipping_number, $carrier->url));
	}
	else
		$errors[] = Tools::displayError('cannot find this order');
}

$smarty->assign('errors', $errors);
$smarty->display(_PS_THEME_DIR_.'order-detail.tpl');

include(dirname(__FILE__).'/footer.php');

?>