<?php

include_once(dirname(__FILE__).'/config/config.inc.php');
include_once(dirname(__FILE__).'/header.php');

$errors = array();

// Class required to manage free orders
class FreeOrder extends PaymentModule
{
}

$step = Tools::getValue('step');

// if some products have disappear
if (!$cart->checkQuantities())
{
	$step = 0;
	$errors[] = Tools::displayError('An item in your cart is no longer available, you cannot proceed with your order');
}

// check minimum account
$shop_purchase = floatval(Configuration::get("PS_PURCHASE_MINIMUM"));
$customer_purchase = Tools::convertPrice($cart->getOrderTotal(), Currency::getCurrency(intval(Configuration::get("PS_CURRENCY_DEFAULT"))));
if ($customer_purchase < $shop_purchase)
{
	$step = 0;
	$customer_purchase_needed = Tools::displayPrice(floatval(Configuration::get("PS_PURCHASE_MINIMUM")), Currency::getCurrency(intval($cart->id_currency)));
	$errors[] = Tools::displayError('A minimum purchase total of').' '.$customer_purchase_needed.' '.Tools::displayError('is required in order to validate your order');
}

if (!$cookie->isLogged() AND in_array($step, array(1, 2, 3)))
	Tools::redirect('authentication.php?back=order.php?step='.$step);

if ($cart->nbProducts())
{
	// Manage discounts
	if ((Tools::isSubmit('submitDiscount') OR isset($_GET['submitDiscount'])) AND Tools::getValue('discount_name'))
	{
		$discountName = Tools::getValue('discount_name');
		if (!Validate::isDiscountName($discountName))
			$errors[] = Tools::displayError('voucher name not valid');
		else
		{
			$discount = new Discount(intval(Discount::getIdByName($discountName)));
			if (is_object($discount) AND $discount->id)
			{
				if ($tmpError = $cart->checkDiscountValidity($discount, $cart->getDiscounts(), $cart->getOrderTotal(), $cart->getProducts(), true))
					$errors[] = $tmpError;
			}
			else
				$errors[] = Tools::displayError('voucher name not valid');
			if (!sizeof($errors))
			{
				$cart->addDiscount(intval($discount->id));
				Tools::redirect('order.php');
			}
			else
			{
				$smarty->assign('errors', $errors);
				$smarty->assign('discount_name', Tools::safeOutput($discountName));
			}
		}
	}
	elseif (isset($_GET['deleteDiscount']) AND Validate::isUnsignedId($_GET['deleteDiscount']))
		$cart->deleteDiscount(intval($_GET['deleteDiscount']));

	// check if there are only virtual product in cart
	if ($cart->isVirtualCart())
	{
		setNoCarrier();
		$smarty->assign('virtualCart', 1);
	}
	else
		$smarty->assign('virtualCart', 0);

	// the 4 steps to order
	switch (intval($step))
	{
		case 1:
			displayAddress();
			break;
		case 2:
			if(Tools::isSubmit('processAddress'))
				processAddress();
			autoStep(2);
			displayCarrier();
			break;
		case 3:
			if(isset($_POST['processCarrier']) OR isset($_POST['processCarrier_x']) OR isset($_POST['processCarrier_y']))
				processCarrier();
			autoStep(3);
			checkFreeOrder();
			displayPayment();
			break;
		default:
			$smarty->assign('errors', $errors);
			displaySummary();
			break;
	}
}
else
{
	// default page
	$smarty->assign('empty', 1);
	$smarty->display(_PS_THEME_DIR_.'shopping-cart.tpl');
}

include(dirname(__FILE__).'/footer.php');


/*
 * Utils functions to manage cart
 *
 */
function autoStep($step)
{
	global $cart;
	if (get_class($cart) != 'Cart')
		die (Tools::displaError());

	if ($step >= 2 AND (!$cart->id_address_delivery OR !$cart->id_address_invoice))
		Tools::redirect('order.php?step=1');
	$delivery = new Address($cart->id_address_delivery);
	$invoice = new Address($cart->id_address_invoice);
	if ($delivery->deleted OR $invoice->deleted)
	{
		if ($delivery->deleted) unset($cart->id_address_delivery);
		if ($invoice->deleted) unset($cart->id_address_invoice);
		Tools::redirect('order.php?step=1');
	}
	elseif ($step >= 3 AND (!$cart->id_carrier AND $cart->id_carrier != 0))
	{
		Tools::redirect('order.php?step=2');
	}
}

/*
 * Payment step pass over
 * Redirect to account client 
 */
function checkFreeOrder()
{
	global $cart;
	if (get_class($cart) != 'Cart')
		die (Tools::displayError());

	if ($cart->getOrderTotal() <= 0)
	{
		$order = new FreeOrder();
		$order->validateOrder(intval($cart->id), 2, 0, 'Free order');
		Tools::redirect('history.php');
	}
}

/**
 * Set id_carrier to 0 (no shipping price)
 *
 */
function setNoCarrier()
{
	global $cart;
	if (get_class($cart) != 'Cart')
		die (Tools::displayError());
	$cart->id_carrier = 0;
	$cart->update();
}

/*
 * Manage address
 */
function processAddress()
{
	global $cart, $smarty;
	$errors = array();
	if (get_class($cart) != 'Cart' OR get_class($smarty) != 'Smarty')
		die (Tools::displayError());
		
	if (!isset($_POST['id_address_delivery']) OR !Address::isCountryActiveById(intval($_POST['id_address_delivery'])))
		$errors[] = 'this address is not in a valid area';
	else
	{
		$cart->id_address_delivery = intval($_POST['id_address_delivery']);
		$cart->id_address_invoice = isset($_POST['same']) ? intval($_POST['id_address_delivery']) : intval($_POST['id_address_invoice']);
		$cart->update();
	
		if (isset($_POST['message']) AND !empty($_POST['message']))
		{
			if (!Validate::isMessage($_POST['message']))
				$errors[] = Tools::displayError('invalid message');
			elseif ($oldMessage = Message::getMessageByCartId(intval($cart->id)))
			{
				$message = new Message(intval($oldMessage['id_message']));
				$message->message = @htmlentities($_POST['message']);
				$message->update();
			}
			else
			{
				$message = new Message();
				$message->message = @htmlentities($_POST['message']);
				$message->id_cart = intval($cart->id);
				$message->id_customer = intval($cart->id_customer);
				$message->add();
			}
		}
	}
	if (sizeof($errors))
	{
		$smarty->assign('errors', $errors);
		displayAddress();
		include_once(dirname(__FILE__).'/footer.php');
		exit;
	}
}

/*
 * Add a carrier
 */
function processCarrier()
{
	global $cart, $smarty;
	
	$errors = array();
	
	if (get_class($cart) != 'Cart')
		die (Tools::displayError());

	$cart->recyclable = (isset($_POST['recyclable']) AND !empty($_POST['recyclable'])) ? 1 : 0;
	
	if (isset($_POST['gift']) AND !empty($_POST['gift']))
	{
	 	if (!Validate::isMessage($_POST['gift_message']))
			$errors[] = Tools::displayError('invalid gift message');
		else
		{
			$cart->gift = 1;
			$cart->gift_message = strip_tags($_POST['gift_message']);
		}
	}
	else
		$cart->gift = 0;

	$address = new Address(intval($cart->id_address_delivery));
	$country = new Country(intval($address->id_country));
	if (isset($_POST['id_carrier']) AND Validate::isInt($_POST['id_carrier']) AND count(Carrier::checkCarrierZone($_POST['id_carrier'], $country->id_zone)))
		$cart->id_carrier = intval($_POST['id_carrier']);
	elseif (!$cart->isVirtualCart())
		$errors[] = Tools::displayError('invalid carrier or no carrier selected');

	$cart->update();
	
	if (sizeof($errors))
	{
		$smarty->assign('errors', $errors);
		displayCarrier();
		include(dirname(__FILE__).'/footer.php');
		exit;
	}
}

/*
 * Display address page (step = 1)
 */
function displayAddress()
{
	global $smarty, $cookie, $cart;
	if (get_class($cart) != 'Cart' OR get_class($smarty) != 'Smarty' OR get_class($cookie) != 'Cookie')
		die (Tools::displayError());
	
	if (!Customer::getAddressesTotalById(intval($cookie->id_customer)))
		Tools::redirect('address.php?back=order.php?step=1');
	$customer = new Customer(intval($cookie->id_customer));
	if (is_object($customer) AND $customer->id)
		$smarty->assign('addresses', $customer->getAddresses(intval($cookie->id_lang)));
	$oldMessage = Message::getMessageByCartId(intval($cart->id));
	if ($oldMessage)
		$smarty->assign('oldMessage', Tools::safeOutput($oldMessage['message']));
	$smarty->assign('cart', $cart);
	$smarty->display(_PS_THEME_DIR_.'order-address.tpl');
}

/*
 * Display carrier page (step = 2)
 */
function displayCarrier()
{
	global $smarty, $cart, $cookie;
	if (get_class($cart) != 'Cart' OR get_class($smarty) != 'Smarty' OR get_class($cookie) != 'Cookie')
		die (Tools::displayError());
	$db = Db::getInstance();
	$address = new Address(intval($cart->id_address_delivery));
	$country = new Country(intval($address->id_country));
	$result = Carrier::getCarriers(intval($cookie->id_lang), true, false, $country->id_zone);
	$resultsArray = array();
	foreach ($result AS $k => $row)
	{
		$row['name'] = (strval($row['name']) != '0' ? $row['name'] : Configuration::get('PS_SHOP_NAME'));
		$row['price'] = number_format($cart->getOrderShippingCost(intval($row['id_carrier'])), 2);
		$row['img'] = file_exists(_PS_SHIP_IMG_DIR_.intval($row['id_carrier']).'.jpg') ? _THEME_SHIP_DIR_.intval($row['id_carrier']).'.jpg' : '';
		$resultsArray[] = $row;
	}
	
	/* If customer already have  accepted the Terms of License */
	$smarty->assign('checkedTOS', $cookie->checkedTOS);

	/* If the shop allow the options "recyclable pack" and/or "gift wrapping" or not */
	$smarty->assign('recyclablePackAllowed', Configuration::get('PS_RECYCLABLE_PACK'));
	$smarty->assign('giftAllowed', Configuration::get('PS_GIFT_WRAPPING'));
	$smarty->assign('conditions', Configuration::get('PS_CONDITIONS'));
	
	/* The customer choice if available */
	$smarty->assign('recyclable', intval($cart->recyclable));
	$smarty->assign('gift', intval($cart->gift));
	
	$smarty->assign('gift_message', strip_tags($cart->gift_message));
	$smarty->assign('carriers', $resultsArray);	
	$smarty->assign('checked', (isset($cart->id_carrier) AND $cart->id_carrier AND is_numeric($cart->id_carrier)) ? intval($cart->id_carrier) : intval(Configuration::get('PS_CARRIER_DEFAULT')));
	$smarty->display(_PS_THEME_DIR_.'order-carrier.tpl');
}

/*
 * Display payment page (step = 3)
 */
function displayPayment()
{
	global $smarty, $cart, $currency, $cookie;
	if (get_class($cart) != 'Cart' OR get_class($smarty) != 'Smarty' OR get_class($currency) != 'Currency')
		die (Tools::displayError());
	$total = $cart->getOrderTotal();
	if (is_numeric($total) AND $total >= 1)
	{
		$cookie->checkedTOS = true;
		$smarty->assign('HOOK_PAYMENT', Module::hookExec('payment'));
	}
	else
		$smarty->assign('errors', array('your order total must be at least '.($currency->format == 1 ? $currency->sign.' ' : '').'1.00'.($currency->format == 2 ? ' '.$currency->sign : '')));
	$smarty->assign('total_price', $total);
	$smarty->display(_PS_THEME_DIR_.'order-payment.tpl');
}

/*
 * Display confirmation page (last step)
 */
function displaySummary()
{
	global $smarty, $cart;
	if (get_class($cart) != 'Cart' OR get_class($smarty) != 'Smarty')
		die (Tools::displayError());
	
	if (file_exists(_PS_SHIP_IMG_DIR_.intval($cart->id_carrier).'.jpg'))
		$smarty->assign('carrierPicture', 1);
	$smarty->assign($cart->getSummaryDetails());
	$smarty->assign('voucherAllowed', Configuration::get('PS_VOUCHERS'));
	$smarty->display(_PS_THEME_DIR_.'shopping-cart.tpl');
}

?>
