<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');

$errors = array();

if (Tools::isSubmit('email'))
{
    if (!($email = Tools::getValue('email')) OR !Validate::isemail($email))
        $errors[] = Tools::displayError('invalid e-mail address');
    else
    {
        $customer = new Customer();
        $customer->getByemail($email);
        if (!Validate::isLoadedObject($customer))
            $errors[] = Tools::displayError('there is no account registered to this e-mail address');
		else
		{
		    $customer->passwd = Tools::encrypt($password = Tools::passwdGen(8));
	        if ($customer->update())
			{
				Mail::Send(intval($cookie->id_lang), 'password', 'Your password', array('{email}' => $customer->email, '{name}' => $customer->name, '{surname}' => $customer->surname, '{passwd}' => $password), $customer->email, $customer->surname.' '.$customer->name);
				$smarty->assign('confirmation', 1);
				$smarty->assign('email', $customer->email);
			}
			else
				$errors[] = Tools::displayError('error with your account and your new password cannot be sent to your e-mail; please report your problem using the contact form');
		}
    }
}

$smarty->assign('errors', $errors);
$smarty->display(_PS_THEME_DIR_.'password.tpl');

include(dirname(__FILE__).'/footer.php');

?>
