<?php

include(dirname(__FILE__).'/config/config.inc.php');
include_once(dirname(__FILE__).'/header.php');
$errors = array();

if (!isset($_GET['id_product']) OR !Validate::isUnsignedId($_GET['id_product']))
	$errors[] = Tools::displayError('product not found');
else
{
	$cookie = new Cookie('ps');
	Tools::setCookieLanguage();
	$product = new Product(intval($_GET['id_product']), true, intval($cookie->id_lang));
	if (!Validate::isLoadedObject($product))
		$errors[] = Tools::displayError('product is no longer available');
	else
	{
		$configs = Configuration::getMultiple(array('PS_ORDER_OUT_OF_STOCK', 'PS_LAST_QTIES'));
		$smarty->assign('product', $product);
		$smarty->assign('features', $product->getFrontFeatures(intval($cookie->id_lang)));
		$smarty->assign('allow_oosp', $product->isAvailableWhenOutOfStock($product->out_of_stock));
		$smarty->assign('last_qties', intval($configs['PS_LAST_QTIES']));
		$hookExtra = Module::hookExec('extra');
		$smarty->assign('HOOK_EXTRA', $hookExtra);
		$smarty->assign('hook_extra_nb', false);
		if (!empty($hookExtra))
			$smarty->assign('hook_extra_nb', true);
		$smarty->assign('HOOK_PRODUCT_FOOTER', Hook::productFooter($product));
		
		$images = $product->getImages(intval($cookie->id_lang));
		foreach ($images AS $k => $image)
		{
			if ($image['cover'])
			{
				$smarty->assign('mainImage', $images[0]);
				$cover = $image;
				$cover['id_image'] = intval($product->id).'-'.$cover['id_image'];
				$cover['id_image_only'] = $image['id_image'];
			}
			$productImages[$image['id_image']] = $image;
		}
		if (!isset($cover))
			$cover = array('id_image' => Language::getIsoById($cookie->id_lang).'-default', 'legend' => 'No picture', 'title' => 'No picture');
		$smarty->assign('cover', $cover);
		$size = Image::getSize('large');
		$smarty->assign('imgWidth', $size['width']);
		if (isset($productImages) AND sizeof($productImages))
			$smarty->assign('images', $productImages);
		$smarty->assign('accessories', $product->getAccessories(intval($cookie->id_lang)));
		
		// Attributes / Groups
		$attributesGroups = $product->getAttributesGroups(intval($cookie->id_lang));
		if (Db::getInstance()->numRows())
		{
			foreach ($attributesGroups AS $k => $row)
			{
				$groups[$row['id_attribute_group']]['name'] = $row['public_group_name'];
				$groups[$row['id_attribute_group']]['attributes'][$row['id_attribute']] = $row['attribute_name'];
				if ($row['default_on'])
					$groups[$row['id_attribute_group']]['default'] = $row['id_attribute'];
				$combinaisons[$row['id_product_attribute']]['attributes'][] = $row['id_attribute'];
				$combinaisons[$row['id_product_attribute']]['price'] = $row['price'];
				$combinaisons[$row['id_product_attribute']]['ecotax'] = $row['ecotax'];
				$combinaisons[$row['id_product_attribute']]['weight'] = $row['weight'];
				$combinaisons[$row['id_product_attribute']]['quantity'] = $row['quantity'];
				$combinaisons[$row['id_product_attribute']]['id_image'] = (($row['id_image'] != NULL) ? $row['id_image'] : -1);
			}			
			foreach ($combinaisons AS $id_product_attribute => $comb)
			{
				$attributeList = '';
				foreach ($comb['attributes'] AS $id_attribute)
					$attributeList .= '\''.$id_attribute.'\',';
				$attributeList = rtrim($attributeList, ',');
				$combinaisons[$id_product_attribute]['list'] = $attributeList;
			}
			$smarty->assign('groups', $groups);
			$smarty->assign('combinaisons', $combinaisons);
		}

		// Features / Values
		$features = $product->getFrontFeatures(intval($cookie->id_lang));
		if (isset($_SERVER['HTTP_REFERER']) AND ereg('^(.*)\/([0-9]+)\-(.*[^\.])|(.*)id_category=([0-9]+)(.*)$', $_SERVER['HTTP_REFERER'], $regs) AND !strstr($_SERVER['HTTP_REFERER'], '.html'))
		{
			if (isset($regs[2]) AND is_numeric($regs[2]))
				$category = new Category(intval($regs[2]), intval($cookie->id_lang));
			elseif (isset($regs[5]) AND is_numeric($regs[5]))
				$category = new Category(intval($regs[5]), intval($cookie->id_lang));
		}
		if (isset($category) AND is_object($category) AND $category->id)
		{
			$smarty->assign('category', $category);
			$smarty->assign('subCategories', $category->getSubCategories(intval($cookie->id_lang), true));
			$smarty->assign('id_category_current', intval($category->id));
			$smarty->assign('id_category_parent', intval($category->id_parent));
			$smarty->assign('return_category_name', Tools::safeOutput(Category::hideCategoryPosition($category->name)));
		}
		$smarty->assign('return_link', (isset($category->id) AND $category->id) ? Tools::safeOutput($link->getCategoryLink($category)) : 'javascript: history.back();');
		$smarty->assign('navigation_pipe', Configuration::get('PS_NAVIGATION_PIPE') ? Configuration::get('PS_NAVIGATION_PIPE') : '>');
		$smarty->assign('path', (isset($category->id) AND $category->id) ? Tools::getPath($category->id, $product->name) : Tools::safeOutput($product->name));
	}
}
$smarty->assign('ENT_NOQUOTES', ENT_NOQUOTES);
$smarty->assign('outOfStockAllowed', Configuration::get('PS_ORDER_OUT_OF_STOCK'));
$smarty->assign('displayPreTax', Configuration::get('PS_DISPLAY_WITHOUT_TAX'));
$smarty->assign('errors', $errors);
$smarty->assign('categories', Category::getHomeCategories(intval($cookie->id_lang)));
$smarty->assign('have_image', Product::getCover(intval(Tools::getValue('id_product'))));
$smarty->assign('display_qties', Configuration::get('PS_DISPLAY_QTIES'));
$smarty->assign('display_ht', Tax::excludeTaxeOption() ^ 1);
$smarty->assign('no_tax', Tax::excludeCustomerTaxeByZone($product->id_tax) | Tax::excludeTaxeOption());
$smarty->display(_PS_THEME_DIR_.'product.tpl');

include(dirname(__FILE__).'/footer.php');

?>