<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');

$nArray = array(10, 20, 50);
$p = abs(intval(Tools::getValue('p', 1)));
if ($p < 0) $p = 0;
$n = abs(intval(Tools::getValue('n', intval(Configuration::get('PS_PRODUCTS_PER_PAGE')))));
if (!$n) $n = $nArray[0];

if ($query = trim(Tools::getValue('search_query')))
{
	if (!Validate::isValidSearch($query))
		$smarty->assign('errors', array(Tools::displayError('invalid search')));
	else
	{
		$search = new Search();
		$nbProducts = intval($search->find(intval($cookie->id_lang), $query, true));
		if ($p > ($nbProducts / $n))
			$p = ceil($nbProducts / $n);
		$smarty->assign('products', $search->find(intval($cookie->id_lang), $query, false, $p, $n));
		$smarty->assign('pages_nb', ceil($nbProducts / intval($n)));
		$smarty->assign('nbProducts', $nbProducts);
		$smarty->assign('query', $query);
	}
}
elseif ($tag = Tools::getValue('tag'))
{
	$search = new Search();
	$smarty->assign('tag', $tag);
	$smarty->assign('query', $tag);
	$nbProducts = intval($search->tag(intval($cookie->id_lang), $tag, true));
	if ($p > ($nbProducts / $n))
		$p = ceil($nbProducts / $n);
	$smarty->assign('products', $search->tag(intval($cookie->id_lang), $tag, false, $p, $n));
	$smarty->assign('pages_nb', ceil($nbProducts / intval($n)));
	$smarty->assign('nbProducts', $nbProducts);
}
else
{
	$smarty->assign('products', array());
	$smarty->assign('pages_nb', 1);
	$smarty->assign('nbProducts', 0);
}

$smarty->assign('p', intval($p));
$smarty->assign('n', intval($n));
$smarty->assign('nArray', $nArray);
$smarty->display(_PS_THEME_DIR_.'search.tpl');

include(dirname(__FILE__).'/footer.php');

?>