<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');

/***************************/
/*  ONLY FOR THEME < V1.0  */
/***************************/

function recurseCategoryBrowsing($categories, $current_category, $category_id = 1) {
	
	/* Image selection */
	global $done;
	global $link;
		
	if (!isset($done[$current_category['infos']['id_parent']]))
		$done[$current_category['infos']['id_parent']] = 0;
	$done[$current_category['infos']['id_parent']] += 1;
		
	$todo = sizeof($categories[$current_category['infos']['id_parent']]);
	$doneC = $done[$current_category['infos']['id_parent']];
	
	$level = $current_category['infos']['level_depth'] + 1;
	$img = ($level == 1 ? 'lv1.gif' : 'lv'.$level.'_'.($todo == $doneC ? 'f' : 'b').'.gif');
	
	/* Return the current item name */
	$result = '<li><div class="cat_tree_img"><img src="'._THEME_IMG_DIR_.'sitemap/'.$img.'" alt="" title="" /></div><div class="cat_tree_text">';
	/* If it's not the Home we link it */
	if ($current_category['infos']['id_category'] != 1)
		$result .= '<a href="'.$link->getCategoryLink($current_category['infos']['id_category'], $current_category['infos']['link_rewrite']).'"'.($level <= 2 ? ' class="bold"' : '').'>';
	/* Return the category name */
	$result .= Category::hideCategoryPosition(stripslashes($current_category['infos']['name']));
	/* Anti-home link */
	if ($current_category['infos']['id_category'] != 1)
		$result .= '</a>';
	$result .= '</div></li>';
	
	/* If the category exists */
	if (isset($categories[$category_id]))
		/* For each category */
		foreach ($categories[$category_id] AS $key => $row)
			/* If it's not informations, browse it */
			if ($key != 'infos' && $row['infos']['active'])
				$result .= recurseCategoryBrowsing($categories, $categories[$category_id][$key], $key);
				
	return $result;
}

function displayCategoryTree() {
	
	global $cookie;

 	/* Categories selection */
 	$category = Category::getCategories(intval($cookie->id_lang), false);
 	if (!$category)
		return false;

 	/* Category browsing */
 	$done = array();
 	$result = '<ul class="categoryTree">';
 	$result .= recurseCategoryBrowsing($category, $category[0][1]);
 	$result .= '</ul>';
 	
 	return $result;
}
$smarty->assign('categoryTree', displayCategoryTree());


/***************************/
/* /ONLY FOR THEME < V1.0  */
/***************************/

/***************************/
/*  ONLY FOR THEME >= V1.0 */
/***************************/

/* Recursive tool */
function recurseLiteCategTree($id_current_category){
	global $link, $cookie;	
	$categ = new Category($id_current_category, intval($cookie->id_lang));
	
	//recursivity for even subcategories
	$children = array();
	$subcats = $categ->getSubCategories(intval($cookie->id_lang), true);
	foreach($subcats as $subcat)
		$children[] = recurseLiteCategTree($subcat['id_category']);
	
	return array(
		'link' => $link->getCategoryLink($id_current_category, $categ->link_rewrite),
		'name' => $categ->name,
		'desc'=> $categ->description,
		'children' => $children
	);
}

//get id rootCateg
$tmp = Category::getCategories(intval($cookie->id_lang), false);
$idRootCateg = $tmp[0][1]['infos']['id_category'];
unset($tmp);

//construct categories tree
$categTree = recurseLiteCategTree($idRootCateg);


//create TPL (here because a recursive fonction is needed)
function constructTreeNode($node){
	$ret = '<li>'."\n";
	$ret .= '<a href="'.$node['link'].'" title="'.strip_tags($node['desc']).'">'.$node['name'].'</a>'."\n";
	if(!empty($node['children']))
	{
		$ret .= '<ul>'."\n";
		foreach ($node['children'] as $child)
			$ret .= constructTreeNode($child);
		$ret .= '</ul>'."\n";
	}
	$ret .= '</li>'."\n";
	return $ret;
}

$ulTree = '<div class="tree-top">' . $categTree['name'] . '</div>'."\n";
$ulTree .=  '<ul class="tree">'."\n";
foreach ($categTree['children'] as $child)
	$ulTree .= constructTreeNode($child);
$ulTree .=  '</ul>'."\n";
$smarty->assign('ulTree', $ulTree);

/***************************/
/* /ONLY FOR THEME >= V1.0 */
/***************************/


$smarty->assign('voucherAllowed', Configuration::get('PS_VOUCHERS'));
$smarty->display(_PS_THEME_DIR_.'sitemap.tpl');
include(dirname(__FILE__).'/footer.php');

?>
