<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');
$errors = array();

$nArray = array(10, 20, 50);
$p = abs(intval(Tools::getValue('p', 1)));
if ($p < 0) $p = 0;
$n = abs(intval(Tools::getValue('n', intval(Configuration::get('PS_PRODUCTS_PER_PAGE')))));
if (!$n) $n = $nArray[0];

if ($id_supplier = Tools::getValue('id_supplier'))
{
	$orderByValues = array(0 => 'name', 1 => 'price', 2 => 'date_add');
	$orderWayValues = array(0 => 'ASC', 1 => 'DESC');
	$orderBy = strtolower(Tools::getValue('orderby', 
	$orderByValues[intval(Configuration::get('PS_PRODUCTS_ORDER_BY'))]));
	$orderWay = strtoupper(Tools::getValue('orderway', 
	$orderWayValues[intval(Configuration::get('PS_PRODUCTS_ORDER_WAY'))]));
	
	if (!in_array($orderWay, array('DESC', 'ASC'))) $orderWay = 'ASC';
	
	$id_supplier = intval($id_supplier);
	$supplier = new Supplier($id_supplier);
	if (!Validate::isLoadedObject($supplier))
		$errors[] = Tools::displayError('supplier does not exist');
	else
	{
		$nbProducts = $supplier->getProducts($id_supplier, NULL, NULL, NULL, $orderBy, $orderWay, true);
		if ($p > ($nbProducts / $n))
			$p = ceil($nbProducts / $n);
		$smarty->assign('pages_nb', ceil($nbProducts / intval($n)));
		$cproducts = $supplier->getProducts($id_supplier, intval($cookie->id_lang), intval($p), intval($n), $orderBy, $orderWay);
		$smarty->assign('nb_products', $nbProducts);
		$smarty->assign('products', (isset($cproducts) AND $cproducts) ? $cproducts : NULL);
		$smarty->assign('supplier', $supplier);
	}
	$smarty->assign('p', intval($p));
	$smarty->assign('n', intval($n));
	$orderby = strval(Tools::getValue('orderby'));
	$orderway = strval(Tools::getValue('orderway'));
	$smarty->assign('nArray', $nArray);
	$smarty->assign('errors', $errors);
	$smarty->assign('path', Tools::safeOutput($supplier->name));
	$smarty->display(_PS_THEME_DIR_.'supplier.tpl');
}
else
{
	$suppliersData = Supplier::getSuppliers(true);
	$suppliers = array();
	if ($suppliersData)
		foreach ($suppliersData AS $supplier)
		{
			if (!file_exists(_PS_MANU_IMG_DIR_.'/'.$supplier['id_supplier'].'-medium.jpg'))
				$supplier['image'] = Language::getIsoById($cookie->id_lang).'-default';
			else
				$supplier['image'] = $supplier['id_supplier'];
			$suppliers[] = $supplier;
		}
	$nbSuppliers = ($suppliers ? count($suppliers) : 0);

	$smarty->assign('pages_nb', ceil($nbSuppliers / intval($n)));
	$smarty->assign('nbSuppliers', $nbSuppliers);
	$smarty->assign('suppliers', $suppliers);
	$smarty->display(_PS_THEME_DIR_.'supplier-list.tpl');
}

include(dirname(__FILE__).'/footer.php');

?>