<h1>{l s='Your addresses'}</h1>
<p class="bold">{if isset($id_address)}{l s='Modify the address'} "{$smarty.post.alias|stripslashes}"{else}{l s='To add a new address, please fill out the form below'}{/if}.</p>
{include file=$tpl_dir./errors.tpl}
<fieldset><legend>{if isset($id_address)}{l s='Your address'}{else}{l s='New address'}{/if}</legend>
	<form action="{$request_uri}" method="post">
		<label>{l s='Company'}</label>
		<div class="margin-form">
			<input type="text" name="company" value="{if isset($smarty.post.company)}{$smarty.post.company|escape:'htmlall,UTF-8'|stripslashes}{/if}" />
		</div>
		<div class="clear"></div>
		<label>{l s='First name'}</label>
		<div class="margin-form">
			<input type="text" name="surname" value="{if isset($smarty.post.surname)}{$smarty.post.surname|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="32" /> <sup class="red_star">*</sup>
		</div>
		<div class="clear"></div>
		<label>{l s='Last name'}</label>
		<div class="margin-form">
			<input type="text" name="name" value="{if isset($smarty.post.name)}{$smarty.post.name|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="32" style="text-transform: uppercase;" /> <sup class="red_star">*</sup>
		</div>
		<div class="clear"></div>
		<label>{l s='Address'}</label>
		<div class="margin-form">
			<input type="text" name="address1" size="42" value="{if isset($smarty.post.address1)}{$smarty.post.address1|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="128" /> <sup class="red_star">*</sup>
		</div>
		<div class="clear"></div>
		<label>{l s='Address (2)'}</label>
		<div class="margin-form">
			<input type="text" name="address2" size="42" value="{if isset($smarty.post.address2)}{$smarty.post.address2|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="128" />
		</div>
		<div class="clear"></div>
		<label>{l s='Postal code / Zip code'}</label>
		<div class="margin-form">
			<input type="text" name="postcode" value="{if isset($smarty.post.postcode)}{$smarty.post.postcode|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="12" /> <sup class="red_star">*</sup>
		</div>
		<div class="clear"></div>
		<label>{l s='City'}</label>
		<div class="margin-form">
			<input type="text" name="city"  value="{if isset($smarty.post.city)}{$smarty.post.city|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="64" /> <sup class="red_star">*</sup>
		</div>
		<div class="clear"></div>
		<label>{l s='Country'}</label>
		<div class="margin-form">
			<select name="id_country">{$countries_list}</select> <sup class="red_star">*</sup>
		</div>
		<div class="clear"></div>
		<label>{l s='Additional information'}</label>
		<div class="margin-form">
			<textarea name="other" cols="26" rows="3">{if isset($smarty.post.other)}{$smarty.post.other|escape:'htmlall,UTF-8'|stripslashes}{/if}</textarea>
		</div>
		<div class="clear"></div>
		<label>{l s='Home phone'}</label>
		<div class="margin-form">
			<input type="text" name="phone" value="{if isset($smarty.post.phone)}{$smarty.post.phone|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="16" />
		</div>
		<div class="clear"></div>
		<label>{l s='Mobile phone'}</label>
		<div class="margin-form">
			<input type="text" name="phone_mobile" value="{if isset($smarty.post.phone_mobile)}{$smarty.post.phone_mobile|escape:'htmlall,UTF-8'|stripslashes}{/if}" maxlength="16" />
		</div>
		<div class="clear"></div>
		<br /><label>{l s='Assign an address title for future reference'}</label>
		<div class="margin-form">
			<input type="text" name="alias" value="{if isset($smarty.post.alias)}{$smarty.post.alias|escape:'htmlall,UTF-8'|stripslashes}{else}{l s='My address'}{/if}" /> <sup class="red_star">*</sup>
		</div>
		<div class="clear"></div>
		<div class="center space">
			<input type="submit" name="submitAddress" value="{l s='Save'}" />
		</div>
		{if isset($id_address)}<input type="hidden" name="a" value="{$id_address}" />{/if}
		{if isset($back)}<input type="hidden" name="back" value="{$back}" />{/if}
	</form>
</fieldset>
<p><sup class="red_star">*</sup> {l s='Required field'}</p>
<div>
	<img src="{$img_dir}arrow2.gif" alt="{l s='Back to your addresses'}" title="{l s='Back to your addresses'}" class="icon" />
	<a href="addresses.php">{l s='Back to Your Addresses'}</a>
</div>