<h1>{l s='Your addresses'}</h1>
{if $addresses}
	<p class="bold">{l s='Your addresses are listed below. Be sure to update them if they have changed.'}</p>
	{foreach from=$addresses item=address}
		<fieldset class="address">
			<legend>{$address.alias}</legend>
			<div class="address_content">
				{if $address.company}{$address.company}<br />{/if}
				{$address.surname} {$address.name}<br />
				{$address.address1}<br />{if $address.address2}{$address.address2}<br />{/if}
				{$address.postcode} {$address.city}<br />
				{$address.country}<br />
				{if $address.phone}{$address.phone}<br />{/if}
				{if $address.phone_mobile}{$address.phone_mobile}<br />{/if}
			</div>
			<div class="address_icons">
				<a href="address.php?id_address={$address.id_address}"><img src="{$img_dir}edit.gif" alt="{l s='Update'}" /></a>
				<a href="address.php?id_address={$address.id_address}&amp;delete" onclick="return confirm('{l s='Are you sure?'}');"><img src="{$img_dir}delete.gif" alt="{l s='Delete'}" /></a>
			</div>
		</fieldset>
	{/foreach}
{else}
	<p class="bold">{l s='No addresses available'}, <a href="address.php">{l s='Add a new one'} !</a></p>
{/if}
<div class="address_menu">
	<img src="{$img_dir}add.gif" alt="+" title="+" class="icon" /> <a href="address.php">{l s='Add an address'}</a>
</div>
<div class="space">
	<img src="{$img_dir}arrow2.gif" alt="&gt;" title="&gt;" class="icon" /> <a href="my-account.php">{l s='Back to Your Account'}</a>
</div>
