{if $errors}
	{include file=$tpl_dir./errors.tpl}
{elseif $category->active}
		<!-- Navigationbar -->
		<div class="nav_bar">
			<a href="{$base_dir}">{l s='Home'}</a> {$navigationPipe} {$path}
		</div>
	
		<!-- Category image -->
		<img src="{$img_cat_dir}{$category->id_image}.jpg" alt="" title="{$category->name}" class="m_bottom" />
	
		<!-- Category name and description -->
		<h1>{$category->name}</h1><br />
		
		{if $category->description}
			<div class="cat_description">{$category->description}</div>
		{/if}
		
		<!-- Subcategories if here -->
		{if isset($subcategories)}
			<div id="categories_list" class="m_bottom">	
				{counter start=0 skip=1 print=false assign=nbCat}
				{foreach from=$subcategories key=k item=subcategory}
					{counter}			
					<div class="subcategory{if ($nbCat - 1) % 3 == 0} clear{/if}">
						<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)}">
							<img src="{$img_cat_dir}{if $subcategory.id_image}{$subcategory.id_image}{else}default{/if}-medium.jpg" alt="" title="{$subcategory.name}" />
						</a>
						<br />
						<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)}">{$subcategory.name}</a>
					</div>
				{/foreach}
			</div>
		{/if}
		
		<!-- Products -->
		{if $products}
			<table class="product_list">
				<tr>
					<th>{l s='Picture'}</th>
					<th>
						{l s='Product'}
						<a href="{$link->goLink('name', 'desc')}"><img src="{$img_dir}down.gif" alt="{l s='down'}" /></a>
						<a href="{$link->goLink('name', 'asc')}"><img src="{$img_dir}up.gif" alt="{l s='up'}" /></a>
					</th>
					<th>
						{l s='Avail.'}
						<a href="{$link->goLink('quantity', 'desc')}"><img src="{$img_dir}down.gif" alt="{l s='down'}" /></a>
						<a href="{$link->goLink('quantity', 'asc')}"><img src="{$img_dir}up.gif" alt="{l s='up'}" /></a>
					</th>
					<th>
						{l s='Price'} 
						<a href="{$link->goLink('price', 'desc')}"><img src="{$img_dir}down.gif" alt="{l s='down'}" /></a>
						<a href="{$link->goLink('price', 'asc')}"><img src="{$img_dir}up.gif" alt="{l s='up'}" /></a>
					</th>
				</tr>
				<tr class="separator">
					<td colspan="4" class="separator"></td>
				</tr>
				
				<!-- Products informations -->
				{foreach from=$products item=product}
				<tr class="product">
					<!-- Image -->
					<td>
						<a href="{$product.link}">
							<img src="{$img_prod_dir}{$product.id_image}-medium.jpg" alt="{$product.legend}" title="{$product.legend}" />
						</a>
					</td>
					
					<!-- Name and description -->
					<td>
						<h3><a href="{$product.link}" class="product_link">{$product.name|truncate:40}</a></h3>
						<div class="cat_prod_description">
							{$product.description_short|strip_tags|truncate:150}
						</div>
					</td>
					
					<!-- Availability -->
					<td class="middle">
						{if ($product.allow_oosp OR $product.quantity > 0)}
							<img src="{$img_dir}available.gif" alt="{l s='Available'}" title="{l s='Available'}" />
						{else}
							<img src="{$img_dir}unavailable.gif" alt="{l s='Out of stock'}" title="{l s='Out of stock'}" />
						{/if}
					</td>
					
					<!-- Price and actions -->
					<td class="price">
						{productPrice p=$product}
						{if ($product.allow_oosp OR $product.quantity > 0)}
							<a href="cart.php?add&amp;id_product={$product.id_product}">
								<img src="{$img_dir}btn-add-small.gif" alt="{l s='Add to cart'}" title="{l s='Add to cart'}" class="add_to_cart" />
							</a>
						{/if}
						<br />
						<a href="{$product.link}" class="product_link">
							<img src="{$img_dir}{$lang_iso}/btn-view.gif" alt="View" title="View" class="tspace" />
						</a>
					</td>
				</tr>
				<tr class="separator2">
					<td colspan="4" class="separator2"></td>
				</tr>
				{/foreach}
			</table>
			{include file=$tpl_dir./pagination.tpl}
		{else}
			<br />{l s='There is no product in this category'}.
		{/if}
{else}
	<p>{l s='This category is currently unavailable'}.</p>
{/if}
