<h1>{l s='Order history'}</h1>

<div class="space">
	{if $orders && count($orders)}
		<b>{l s='Here are the orders you have placed since the creation of your account'}.</b><br /><br /><br />
	
		<table class="history red_link">
			<tr>
				<th class="history_ref">{l s='Order'}</th>
				<th class="history_date">{l s='Date'}</th>
				<th class="history_price">{l s='Total price'}</th>
				<th class="history_method">{l s='Payment method'}</th>
				<th class="history_state">{l s='Status'}</th>
				<th class="history_invoice">{l s='Invoice'}</th>
			</tr>
			<tr class="separator">
				<td class="separator" colspan="7"></td>
			</tr>
			{counter start=0 skip=1 print=false assign=nbOrder}
			{foreach from=$orders item=order}
				{counter}
				<tr {if $nbOrder % 2}class="bg_order"{/if}>
					<td style="height: 25px;"><a href="order-detail.php?id_order={$order.id_order}" class="history">FA{$order.id_order|string_format:"%06d"}</a></td>
					<td>{dateFormat date=$order.date_add full=0}</td>
					<td>{$order.total_paid}</td>
					<td>{$order.payment}</td>
					<td>{$order.order_state}</td>
					<td>
						{if $order.invoice}
						<a href="pdf-invoice.php?id_order={$order.id_order}">
							<img src="{$img_dir}pdf.gif" alt="{l s='Invoice'} {$order.name}" title="{l s='Invoice'} {$order.name}" />
						</a>{else}-{/if}
					</td>
				</tr>
				<tr class="separator2">
					<td class="separator2" colspan="7"></td>
				</tr>
			{/foreach}
		</table>
	{else}
		{l s='You have not placed any orders'}.
	{/if}
	
	<p class="space">
		<a href="my-account.php"><img src="{$img_dir}arrow2.gif" alt="{l s='Back to my account'}" title="{l s='Back to my account'}" class="img_middle" /></a> 
		<a href="my-account.php">{l s='Back to Your Account'}</a>
		<a href="{$base_dir}"><img src="{$img_dir}arrow2.gif" alt="{l s='Home'}" title="{l s='Home'}" class="img_middle" /></a> 
		<a href="{$base_dir}">{l s='Home'}</a>
	</p>
</div>