{if isset($errors) AND $errors}
	{include file=$tpl_dir./errors.tpl}
{else}
	<!-- Navigationbar -->
	<div class="nav_bar">
		<a href="{$base_dir}">{l s='Home'}</a> &gt;
		{if isset($path) AND $path}{$path}{else}{l s='Manufacturers'}{/if}
	</div>
	<!-- Page title -->
	<h1>{l s='Manufacturers'}</h1>

	<!-- Nb manufacturers -->
	<h4>{l s='There are'} {$nbManufacturers} {if $nbManufacturers > 1}{l s='manufacturers'}{else}{l s='manufacturer'}{/if}.</h4>

	<!-- Manufacturers list -->
	<table class="manufacturer_list">
		<tr>
			<th>{l s='Picture'}</th>
			<th>{l s='Name'}</th>
		</tr>
		<tr class="separator">
			<td colspan="4" class="separator"></td>
		</tr>
	
		<!-- Manufacturers informations -->
		{foreach from=$manufacturers item=manufacturer}
		<tr class="manufacturer_row">
			<!-- Image -->
			<td>
				{if $manufacturer.nb_products > 0}<a href="{$SCRIPT_NAME}?id_manufacturer={$manufacturer.id_manufacturer}" title="{$manufacturer.name}" class="manufacturer_img">{/if}<img src="{$img_manu_dir}{$manufacturer.image}-medium.jpg" alt="{$manufacturer.name}" />{if $manufacturer.nb_products > 0}</a>{/if}
			</td>
			<!-- Name -->
			<td>
				<h3>{if $manufacturer.nb_products > 0}<a href="{$SCRIPT_NAME}?id_manufacturer={$manufacturer.id_manufacturer}" class="manufacturer_link">{/if}{$manufacturer.name|truncate:40}{if $manufacturer.nb_products > 0}</a>{/if}</h3>
				<p>
					{if $manufacturer.nb_products > 0}
						<a href="{$SCRIPT_NAME}?id_manufacturer={$manufacturer.id_manufacturer}">{l s='View this manufacturer\'s products'}</a>
					{else}
						{l s='No product for this manufacturer'}
					{/if}
				</p>
			</td>
			<tr class="separator2">
				<td colspan="4" class="separator2"></td>
			</tr>
		{/foreach}
	</table>
	{include file=$tpl_dir./pagination.tpl}
{/if}