<h1>{l s='Order details'} FA{$order->id|string_format:"%06d"}</h1>

{if $errors}
	{include file=$tpl_dir./errors.tpl}
{else}
	{if count($order_history)}
	<div class="detail_follow">
		<h2 class="detail">{l s='Follow your order step by step'}</h2>
		<table class="detail_step_by_step">
			<tr>
				<th class="detail_date">{l s='Date'}</th>
				<th class="detail_status">{l s='Status'}</th>
			</tr>
			<tr class="separator">
				<td class="separator" colspan="2"></td>
			</tr>
			{foreach from=$order_history item=state}
				<tr>
					<td>{dateFormat date=$state.date_add full=1}</td><td>{$state.ostate_name}</td>
				</tr>
			{/foreach}
		</table>
	</div>
	{/if}<br />
	
	{if $followup}
	<div class="detail_follow">
		<h2 class="detail">{l s='Click the following link to track delivery of your order'}</h2>
		<a href="{$followup}">{$followup}</a>
	</div>
{/if}
	
	<div class="detail_follow">
		<h2 class="detail">{l s='Details'}</h2>
		<div class="detail_details">
			<b>{l s='Payment method'}:</b> {$order->payment}<br />
			<b>{l s='Carrier'}:</b> {$carrier->name}
			{if $order->recyclable}
				<br /><br /><img src="{$img_dir}world.gif" alt="" title="{l s='You have given permission to receive your order in recycled packaging'}" style="float: left;" />&nbsp;
				{l s='You have given permission to receive your order in recycled packaging'}
			{/if}
			{if $order->gift}
				<br /><img src="{$img_dir}gift.gif" alt="" title="{l s='You requested gift-wrapping for your order'}" style="float: left;" />&nbsp;
				{l s='You requested gift-wrapping for your order'}.<br />
				<span style="margin-left:22px;">{l s='Message:'}</span>
				<i>{$order->gift_message}</i><br />
			{/if}
			{if $invoice}
				<br />
				<a href="{$base_dir}pdf-invoice.php?id_order={$order->id}"><img src="{$img_dir}pdf.gif" alt="{l s='Invoice'}" title="{l s='Invoice'}" style="float: left; border: none;" /></a>&nbsp;
				<a href="{$base_dir}pdf-invoice.php?id_order={$order->id}">{l s='Download your invoice as a .PDF file'}</a>
			{/if}
		</div>
	</div>
	
	<div class="detail_follow">
		<h2 class="detail">{l s='Delivery and Invoicing'}</h2>
		<div class="detail_invoice_address" style="">
			{l s='Invoice'}<br />
			{if $address_invoice->company}{$address_invoice->company}<br />{/if}
			<span style="font-weight: bold;">{$address_invoice->name|upper} {$address_invoice->surname}</span><br />
			{$address_invoice->address1}<br />
			{if $address_invoice->address2}{$address_invoice->address2}<br />{/if}
			{$address_invoice->postcode} {$address_invoice->city|upper}<br />
			{$address_invoice->country|upper}
		</div>
		<div class="detail_invoice_address" class="center">
			{l s='Delivery'}<br />
			{if $address_delivery->company}{$address_delivery->company}<br />{/if}
			<span style="font-weight: bold;">{$address_delivery->name|upper} {$address_delivery->surname}</span><br />
			{$address_delivery->address1}<br />
			{if $address_delivery->address2}{$address_delivery->address2}<br />{/if}
			{$address_delivery->postcode} {$address_invoice->city|upper}<br />
			{$address_delivery->country|upper}
		</div>
		<div style="clear:both">&nbsp;</div>
	</div>
	
	<h2 class="detail2">{l s='Invoicing'}</h2>
	<table class="order_detail">
		<tr>
			<th class="order_detail_ref">{l s='Reference'}</th>
			<th class="order_detail_name">{l s='Product'}</th>
			<th class="order_detail_quantity">{l s='Qty'}</th>
			<th class="order_detail_unit_price">{l s='Unit price'}</th>
			<th class="order_detail_price">{l s='Total price'}</th>
		</tr>
		{counter start=0 skip=1 print=false assign=nbProd}
		{foreach from=$products item=product}
			<tr{if !$nbProd} class="noborder"{/if}>
				<td>{if $product.product_reference}{$product.product_reference}{else}--{/if}</td>
				<td>{if $product.download_hash && $invoice}<a href="getFile.php?key={$product.filename}-{$product.download_hash}" title="{l s='Download'}: {$product.product_name}"><img src="{$img_dir}icon/download_product.png" alt="{l s='Download product'}" />&nbsp;{$product.product_name}</a>{else}{$product.product_name}{/if}</td>
				<td class="right">{$product.product_quantity}</td>
				<td class="right">{convertPriceWithCurrency price=$product.product_price_wt currency=$currency}</td>
				<td class="right">{convertPriceWithCurrency price=$product.total_wt currency=$currency}</td>
			</tr>
		{counter}
		{/foreach}
		{foreach from=$discounts item=discount}
			<tr style="height: 25px;">
				<td>{$discount.name}</td>
				<td>Code de r&eacute;duction {$discount.name}</td>
				<td>1</td>
				<td></td>
				<td>-{convertPrice price=$discount.value}</td>
			</tr>
		{/foreach}
		<tr>
			<td colspan="6" class="special_total">
				{l s='Total products'} : {displayWtPriceWithCurrency price=$order->getTotalProductsWithTaxes() currency=$currency convert=1}
			</td>
		</tr>
		<tr>
			<td colspan="6" class="special_total2">
				{l s='Total vouchers'} : {displayWtPriceWithCurrency price=$order->total_discounts currency=$currency convert=1}
			</td>
		</tr>
		<tr>
			<td colspan="6" class="special_total2">
				{l s='Total delivery'} : {displayWtPriceWithCurrency price=$order->total_shipping currency=$currency convert=1}
			</td>
		</tr>
		<tr>
			<td colspan="6" class="special_total2">
				{l s='Total'} : {displayWtPriceWithCurrency price=$order->total_paid currency=$currency convert=0}
			</td>
		</tr>
	</table>
	<br />
	
	{if $messages}
		<div class="detail_follow">
		<h2>{l s='Messages'}</h2>
		{foreach from=$messages item=message}
			({dateFormat date=$message.date_add full=1})<b>
			{if $message.ename}
				{$message.esurname} {$message.ename}
			{else}
				{$message.csurname} {$message.cname}
			{/if}
			</b>: {$message.message}<br />
		{/foreach}
		</div>
	{/if}
	
	<form action="{$request_uri}" method="post">
		<h2 class="detail2">{l s='Add a message'}</h2>
		<textarea name="msgText" cols="42" rows="6"></textarea><br /><br />
		<input type="hidden" name="id_order" value="{$order->id}" />
		<input type="hidden" name="id_customer" value="{$order->id_customer}" />
		<input type="image" src="{$img_dir}{$lang_iso}/btn-submit.gif" class="button" name="submitMessage" value="{l s='Send'}"/>
	</form><br />
{/if}

<br />
<a href="history.php"><img src="{$img_dir}arrow2.gif" alt="{l s='Back to orders'}" title="{l s='Back to orders'}" class="img_middle" /></a> 
<a href="history.php">{l s='Back to Orders'}</a>