<h1>{l s='Search'} {if $nbProducts > 0}"{$query}"{/if}</h1>
{include file=$tpl_dir./errors.tpl}

{if !$nbProducts}
	<p>
		{if $query}{l s='No results found for your search'} "{$query}".
		{else}{l s='Please type a search keyword'}{/if}
	</p>
{else}
	<p><b>{$nbProducts}</b> {if $nbProducts == 1}{l s='result has been found'}{else}{l s='results have been found'}{/if}.</p>
	<table class="product_list">
		<!-- Products informations -->
		<tr>
			<th>{l s='Picture'}</th>
			<th>{l s='Product'}</th>
			<th>{l s='Avail.'}</th>
			<th>{l s='Price'}</th>
		</tr>
		<tr class="separator">
			<td colspan="4" class="separator"></td>
		</tr>
		{foreach from=$products item=product}
		<tr class="product">
			<!-- Image -->
			<td>
				<a href="{$product.link}">
					<img src="{$img_prod_dir}{$product.id_image}-medium.jpg" alt="{$product.legend}" title="{$product.legend}" />
				</a>
			</td>
			
			<!-- Name and description -->
			<td>
				<h3><a href="{$product.link}" class="product_link">{$product.name|truncate:40}</a>{if $product.score} ({$product.score}%){/if}</h3>
				<div class="cat_prod_description">
					{$product.description_short|strip_tags|truncate:150}
				</div>
			</td>
			
			<!-- Availability -->
			<td class="middle">
				{if ($product.allow_oosp OR $product.quantity > 0)}
					<img src="{$img_dir}available.gif" alt="{l s='Available'}" title="{l s='Available'}" />
				{else}
					<img src="{$img_dir}unavailable.gif" alt="{l s='Out of stock'}" title="{l s='Out of stock'}" />
				{/if}
			</td>
			
			<!-- Price and actions -->
			<td class="price">
				<!-- METTRE LA MISE EN FORME ICI ET NON PLUS dans class/Product.php productPrice() !!
				<span class="price">{productPrice p=$product}</span>-->
				{productPrice p=$product}
				{if ($product.allow_oosp OR $product.quantity > 0)}
					<a href="cart.php?add&id_product={$product.id_product}">
						<img src="{$img_dir}btn-add-small.gif" alt="{l s='Add to cart'}" title="{l s='Add to cart'}" class="add_to_cart" />
					</a>
				{/if}
				<br />
				<a href="{$product.link}" class="product_link">
					<img src="{$img_dir}{$lang_iso}/btn-view.gif" alt="View" title="View" class="tspace" />
				</a>
			</td>
		</tr>
		<tr class="separator2">
			<td colspan="4" class="separator2"></td>
		</tr>
		{/foreach}
	</table>
	{include file=$tpl_dir./pagination.tpl}
{/if}