<h1>{l s='Shopping cart summary'}</h1>
{include file=$tpl_dir./errors.tpl}
{if isset($empty)}
	<p>{l s='Your shopping cart is empty.'}</p>
{else}
	<p>{l s='Your shopping cart contains'} {$products|@count} {if $products|@count > 1}{l s='products'}{else}{l s='product'}{/if}</p>
	<table cellspacing="0" cellpadding="4" class="cart_tab">
		<tr>
			<th class="cart_ref">{l s='Ref.'}</th>
			<th class="cart_picture">{l s='Pic.'}</th>
			<th class="cart_product">{l s='Product'}</th>
			<th class="cart_availability">{l s='Avail.'}</th>
			<th class="cart_unit">{l s='Unit price'}</th>
			<th class="cart_quantity">{l s='Qty'}</th>
			<th class="cart_total">{l s='Total'}</th>
		</tr>
		
		{foreach from=$products item=product}
		<tr class="cart_entry">
			<td class="cart_ref">{if $product.reference}{$product.reference}{else}--{/if}</td>
			<td class="cart_tab_img">
				<a><img src="{$img_dir}camera.gif" alt="{l s='Zoom'}" title="{l s='Zoom'}" />
				<span><img src="{$img_prod_dir}{$product.id_image}-medium.jpg" alt="{$product.name}" title="{$product.name}" /></span></a>
			</td>
			<td><a href="{$link->getProductLink($product.id_product, $product.link_rewrite)}">{$product.name} {$product.attributes}</a></td>
			<td class="cart_availability">
				{if $product.allow_oosp OR $product.stock_quantity > 0}
					<img src="{$img_dir}available.gif" alt="{l s='Available'}" title="{l s='Available'}" />
				{else}
					<img src="{$img_dir}unavailable.gif" alt="{l s='Out of stock'}" title="{l s='Out of stock'}" />
				{/if}
			</td>
			<td  class="cart_unit">{convertPrice price=$product.price_wt}</td>
			<td class="cart_quantity">
				<div class="qty_right">
					<a href="cart.php?delete&amp;id_product={$product.id_product}&amp;ipa={$product.id_product_attribute}">
						<img src="{$img_dir}delete.gif" alt="{l s='Delete'}" title="{l s='Delete'}" />
					</a>
				</div>
				<div class="qty_middle">
					<a href="cart.php?add&amp;id_product={$product.id_product}&amp;ipa={$product.id_product_attribute}">
						<img src="{$img_dir}quantity_up.gif" alt="{l s='Add'}" title="{l s='Add'}" />
					</a>
					<a href="cart.php?add&amp;id_product={$product.id_product}&amp;ipa={$product.id_product_attribute}&amp;op=down">
						<img src="{$img_dir}quantity_down.gif" alt="{l s='Delete'}" title="{l s='Delete'}" />
					</a>
				</div>				
				<div class="qty_left">
					{$product.quantity}
				</div>				
			</td>
			<td class="cart_total">{convertPrice price=$product.total_wt}</td>
		</tr>
		{/foreach}
		{foreach from=$discounts item=discount}
		<tr class="cart_tab_discount cart_tab_td">
			<td colspan="2" class="uppercase">{$discount.name}</td>
			<td colspan="3" class="uppercase">{$discount.description}</td>
			<td align="right" class="cart_quantity"><a href="order.php?deleteDiscount={$discount.id_discount}"><img src="{$img_dir}delete.gif" alt="{l s='Delete'}" title="{l s='Delete'}" /></a></td>
			<td align="right">-{convertPrice price=$discount.value_real}</td>
		</tr>
		{/foreach}
		<tr class="right"><td colspan="7" style="height: 20px;">{l s='Total products'}: {convertPrice price=$total_products_wt}</td></tr>
		<tr class="right"><td colspan="7" style="height: 20px;">{l s='Total vouchers'}: {convertPrice price=$total_discounts}</td></tr>
		{if $carrier->id}<tr class="right"><td colspan="7" style="height: 20px;">{l s='Total delivery'}: {convertPrice price=$total_shipping}</td></tr>{/if}
		<tr class="right"><td colspan="7" style="height: 20px;"><b>{l s='Total'}{if !$carrier->id} {l s='(except delivery costs)'}{/if}: {convertPrice price=$total_price}</b></td></tr>
	</table>

	{if $voucherAllowed}
		<div class="cart_voucher">
			{if $errors_discount}
				<ul class="error">
				{foreach from=$errors_discount key=k item=error}
					<li>{$error}</li>
				{/foreach}
				</ul>
			{/if}
			<fieldset class="voucher"><legend>{l s='Vouchers'}</legend>
				<form action="{$smarty.server.PHP_SELF}" method="post">
					<div>{l s='Code:'}</div>
					<div style="margin-top: 10px;">
						<input type="text" name="discount_name" value="{if $discount_name}{$discount_name}{/if}" />
						<input type="submit" name="submitDiscount" value="{l s='Add'}" />
					</div>
				</form>
			</fieldset>
		</div>
		<div class="clear"></div>
	{/if}

{if ($carrier->id AND !$virtualCart) OR $delivery->id OR $invoice->id}
	<div class="order_delivery">
		{if $delivery->id}
			<div class="delivery_address">
				<b><u>{l s='Delivery address'}:</u></b> {$delivery->alias}</u></b><br />
				{$delivery->name} {$delivery->surname}<br />
				{$delivery->address1}<br />
				{if $delivery->address2}{$delivery->address2}<br />{/if}
				{$delivery->postcode} {$delivery->city}<br />
				{$delivery->country}
			</div>
		{/if}
		{if $invoice->id}
			<div class="invoice_address">
				<b><u>{l s='Invoice address'}:</u></b> {$invoice->alias}<br />
				{$invoice->name} {$invoice->surname}<br />
				{$invoice->address1}<br />
				{if $invoice->address2}{$invoice->address2}<br />{/if}
				{$invoice->postcode} {$invoice->city}<br />
				{$invoice->country}
			</div>
		{/if}
		{if $carrier->id AND !$virtualCart}
			<div class="order_carrier">
				<b><u>{l s='Carrier'}:</u></b>
				{if isset($carrierPicture)}<br /><img src="{$img_ship_dir}{$carrier->id}.jpg" alt="{l s='Carrier'}" title="{l s='Carrier'}" />{/if}
				&nbsp;&nbsp;{$carrier->name}
			</div>
		{/if}
	</div>
{/if}

	<div class="order_navigation">
		<a href="order.php?step=1">
			<img class="special_next" src="{$img_dir}{$lang_iso}/btn-next.gif" alt="{l s='Next'}" title="{l s='Next'}" />
		</a>
		<a href="{if $smarty.server.HTTP_REFERER}{$smarty.server.HTTP_REFERER}{else}{$base_dir}index.php{/if}">
			<img src="{$img_dir}{$lang_iso}/btn-continue.gif" alt="{l s='Continue shopping'}" title="{l s='Continue shopping'}" />
		</a>
	</div>
	
{/if}