{if isset($errors) AND $errors}
	{include file=$tpl_dir./errors.tpl}
{else}
	<!-- Navigationbar -->
	<div class="nav_bar">
		<a href="{$base_dir}">{l s='Home'}</a> &gt;
		{if isset($path) AND $path}{$path}{else}{l s='Suppliers'}{/if}
	</div>
	<!-- Page title -->
	<h1>{l s='Suppliers'}</h1>

	<!-- Nb suppliers -->
	<h4>{l s='There are'} {$nbSuppliers} {if $nbSuppliers > 1}{l s='suppliers'}{else}{l s='supplier'}{/if}.</h4>

	<!-- Suppliers list -->
	<table class="supplier_list">
		<tr>
			<th>{l s='Picture'}</th>
			<th>{l s='Name'}</th>
		</tr>
		<tr class="separator">
			<td colspan="4" class="separator"></td>
		</tr>
	
		<!-- Suppliers informations -->
		{foreach from=$suppliers item=supplier}
		<tr class="supplier_row">
			<!-- Image -->
			<td>
				{if $supplier.nb_products > 0}<a href="{$SCRIPT_NAME}?id_supplier={$supplier.id_supplier}" title="{$supplier.name}" class="supplier_img">{/if}<img src="{$img_sup_dir}{$supplier.image}-medium.jpg" alt="{$supplier.name}" />{if $supplier.nb_products > 0}</a>{/if}
			</td>
			<!-- Name -->
			<td>
				<h3>{if $supplier.nb_products > 0}<a href="{$SCRIPT_NAME}?id_supplier={$supplier.id_supplier}" class="supplier_link">{/if}{$supplier.name|truncate:40}{if $supplier.nb_products > 0}</a>{/if}</h3>
				<p>
					{if $supplier.nb_products > 0}
						<a href="{$SCRIPT_NAME}?id_supplier={$supplier.id_supplier}">{l s='View this supplier\'s products'}</a>
					{else}
						{l s='No product for this supplier'}
					{/if}
				</p>
			</td>
			<tr class="separator2">
				<td colspan="4" class="separator2"></td>
			</tr>
		{/foreach}
	</table>
	{include file=$tpl_dir./pagination.tpl}
{/if}