{if $errors}
	{include file=$tpl_dir./errors.tpl}
{else}
	<!-- Navigationbar -->
	<div class="nav_bar">
		<a href="{$base_dir}">{l s='Home'}</a> &gt;
		{if isset($path) AND $path}{$path}{else}{l s='Suppliers'}{/if}
	</div>
	
	<!-- Page title -->
	<h1>{l s='List of products by supplier:'}&nbsp;{$supplier->name}</h1>

	<!-- Products supplier list -->
	<table class="product_list">
	
	<!-- Products informations -->
	{if $products}
			<tr>
				<th>{l s='Picture'}</th>
				<th>
					{l s='Product'}
					<a href="{$link->goLink('name', 'desc')}&amp;id_supplier={$supplier->id}"><img src="{$img_dir}down.gif" alt="{l s='down'}" /></a>
					<a href="{$link->goLink('name', 'asc')}&amp;id_supplier={$supplier->id}"><img src="{$img_dir}up.gif" alt="{l s='up'}" /></a>
				</th>
				<th>
					{l s='Avail.'}
					<a href="{$link->goLink('quantity', 'desc')}&amp;id_supplier={$supplier->id}"><img src="{$img_dir}down.gif" alt="{l s='down'}" /></a>
					<a href="{$link->goLink('quantity', 'asc')}&amp;id_supplier={$supplier->id}"><img src="{$img_dir}up.gif" alt="{l s='up'}" /></a>
				</th>
				<th>
					{l s='Price'} 
					<a href="{$link->goLink('price', 'desc')}&amp;id_supplier={$supplier->id}"><img src="{$img_dir}down.gif" alt="{l s='down'}" /></a>
					<a href="{$link->goLink('price', 'asc')}&amp;id_supplier={$supplier->id}"><img src="{$img_dir}up.gif" alt="{l s='up'}" /></a>
				</th>
			</tr>
			<tr class="separator">
				<td colspan="4" class="separator"></td>
			</tr>
			
			<!-- Products informations -->
			{foreach from=$products item=product}
			<tr class="product">
				<!-- Image -->
				<td>
					<a href="{$product.link}">
						<img src="{$img_prod_dir}{$product.id_image}-medium.jpg" alt="{$product.legend}" title="{$product.legend}" />
					</a>
				</td>
				
				<!-- Name and description -->
				<td>
					<h3><a href="{$product.link}" class="product_link">{$product.name|truncate:40}</a></h3>
					<div class="cat_prod_description">
						{$product.description_short|strip_tags|truncate:150}
					</div>
				</td>
				
				<!-- Availability -->
				<td class="middle">
					{if ($product.allow_oosp OR $product.quantity > 0)}
						<img src="{$img_dir}available.gif" alt="{l s='Available'}" title="{l s='Available'}" />
					{else}
						<img src="{$img_dir}unavailable.gif" alt="{l s='Out of stock'}" title="{l s='Out of stock'}" />
					{/if}
				</td>
				
				<!-- Price and actions -->
				<td class="price">
					{productPrice p=$product}
					{if ($product.allow_oosp OR $product.quantity > 0)}
						<a href="cart.php?add&amp;id_product={$product.id_product}">
							<img src="{$img_dir}btn-add-small.gif" alt="{l s='Add to cart'}" title="{l s='Add to cart'}" class="add_to_cart" />
						</a>
					{/if}
					<br />
					<a href="{$product.link}" class="product_link">
						<img src="{$img_dir}{$lang_iso}/btn-view.gif" alt="View" title="View" class="tspace" />
					</a>
				</td>
			</tr>
			<tr class="separator2">
				<td colspan="4" class="separator2"></td>
			</tr>
			{/foreach}
		</table>
	{include file=$tpl_dir./pagination.tpl}
	{else}
			<tr class="product">
				<td colsplan="4" style="text-align:center; padding:20px 0px 20px 0px;">{l s='No products for this supplier'}</td>
			</tr>
		</table>
	{/if}
{/if}